
#ifndef __NETXTRANSPORT_LINUX__H
#define __NETXTRANSPORT_LINUX__H

#include <cifXUser.h>

#ifdef __cplusplus
extern "C"
{
#endif

struct CIFX_LINUX_INIT
{
  int                   init_options;   /*!< see CIFX_DRIVER_INIT_XXX defines */

  const char*           base_dir;       /*!< base directory for device configuration */
  unsigned long         poll_interval;  /*!< Poll interval in ms for non-irq cards   */
  int                   poll_priority;  /*!< Poll thread priority                    */
  unsigned long         trace_level;    /*!< see TRACE_LVL_XXX defines               */
  int                   user_card_cnt;  /*!< Number of user defined cards            */
  struct CIFX_DEVICE_T* user_cards;     /*!< Pointer to Array of user cards (must be user_card_cnt long) */

  int                   iCardNumber;
  int                   fEnableCardLocking;
  int                   poll_StackSize;   /*!< Stack size of polling thread            */
  int                   poll_schedpolicy; /*!< Schedule policy of poll thread          */
};

int32_t cifXDriverInit( const struct CIFX_LINUX_INIT* init);
void cifXDriverDeinit();

#ifdef __cplusplus
}
#endif

#endif /* __NETXTRANSPORT_LINUX__H */
